/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWSIMRolesTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    public static final int COL_NAME = 0;
    public static final int COL_QUEUES = 1;
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_rowData = null;
    private int m_roleNameCount = 0;

    public VWSIMRolesTableModel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_rowData = new Vector();
    }

    public void reinitialize() {
        int roleCount;
        this.m_roleNameCount = 0;
        this.m_rowData.removeAllElements();
        Object[] roleDefs = this.m_propertyData.getScenarioDefinition().getRoles();
        if (roleDefs != null && (roleCount = roleDefs.length) > 0) {
            try {
                VWQubbleSort sort = new VWQubbleSort();
                VWQubbleSort.sort(roleDefs);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            for (int i = 0; i < roleCount; ++i) {
                this.m_rowData.addElement(roleDefs[i]);
            }
        }
        this.fireTableDataChanged();
    }

    public VWScenarioRoleDefinition getItemAt(int row) {
        VWScenarioRoleDefinition roleDef = null;
        try {
            int rowDataCount = this.m_rowData.size();
            if (rowDataCount > 0 && row >= 0 && row < rowDataCount) {
                roleDef = (VWScenarioRoleDefinition)this.m_rowData.elementAt(row);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return roleDef;
    }

    public void addItem() {
        VWScenarioRoleDefinition newRoleDef = null;
        try {
            String name = null;
            boolean success = false;
            while (!success) {
                name = VWSIMResource.s_job + ++this.m_roleNameCount;
                try {
                    newRoleDef = this.m_propertyData.getScenarioDefinition().createRole(name);
                    success = true;
                }
                catch (Exception ex) {}
            }
            this.m_rowData.addElement(newRoleDef);
            this.m_propertyData.setDirty();
            this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 115, newRoleDef);
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void addItem(Object newRoleObj) {
        try {
            if (newRoleObj != null && newRoleObj instanceof VWScenarioRoleDefinition) {
                this.m_rowData.addElement((VWScenarioRoleDefinition)newRoleObj);
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void copyItem(int row) {
        try {
            VWScenarioRoleDefinition roleDef = this.getItemAt(row);
            if (roleDef != null) {
                String name = VWSIMResource.s_copyOf + " " + roleDef.getName();
                VWScenarioQueueAssignment[] queueAssignments = roleDef.getQueueAssignments();
                VWScenarioRoleDefinition newRoleDef = this.m_propertyData.getScenarioDefinition().createRole(name, roleDef);
                this.m_rowData.addElement(newRoleDef);
                this.m_propertyData.setDirty();
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 115, newRoleDef);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int row) {
        try {
            VWScenarioRoleDefinition roleDef = this.getItemAt(row);
            if (roleDef != null) {
                String name = roleDef.getName();
                this.m_propertyData.deleteRoleAssignments(roleDef);
                this.m_propertyData.getScenarioDefinition().deleteRole(name);
                this.m_rowData.removeElementAt(row);
                this.m_propertyData.setDirty();
                this.fireTableRowsDeleted(row, row);
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 116, name);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        Class resultClass = null;
        switch (nColumnIndex) {
            case 0: {
                resultClass = String.class;
                break;
            }
            case 1: {
                resultClass = VWScenarioQueueAssignment.class;
            }
        }
        return resultClass;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return VWSIMResource.s_name;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int row, int col) {
        try {
            VWScenarioRoleDefinition roleDef = this.getItemAt(row);
            switch (col) {
                case 0: {
                    if (roleDef != null) {
                        return roleDef.getName();
                    }
                    return new String("");
                }
                case 1: {
                    if (roleDef == null) break;
                    return roleDef.getQueueAssignments();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                this.onUpdateName(value, row);
            }
        }
    }

    private void onUpdateName(Object value, int row) {
        try {
            VWScenarioRoleDefinition roleDef;
            String name = (String)value;
            if (name != null && name.length() > 0 && (roleDef = this.getItemAt(row)) != null) {
                String oldName = roleDef.getName();
                roleDef.setName(name);
                this.m_propertyData.setDirty();
                this.fireTableCellUpdated(row, 0);
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 117, new String[]{oldName, name});
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }
}

